type CacheLifeConfig = {
    expire?: number;
};
/**
 * This function allows you to purge [cached data](https://nextjs.org/docs/app/building-your-application/caching) on-demand for a specific cache tag.
 *
 * Read more: [Next.js Docs: `revalidateTag`](https://nextjs.org/docs/app/api-reference/functions/revalidateTag)
 */
export declare function revalidateTag(tag: string, profile: string | CacheLifeConfig): undefined;
/**
 * This function allows you to update [cached data](https://nextjs.org/docs/app/building-your-application/caching) on-demand for a specific cache tag.
 * This can only be called from within a Server Action to enable read-your-own-writes semantics.
 *
 * Read more: [Next.js Docs: `updateTag`](https://nextjs.org/docs/app/api-reference/functions/updateTag)
 */
export declare function updateTag(tag: string): undefined;
/**
 * This function allows you to refresh client cache from server actions.
 * It's useful as dynamic data can be cached on the client which won't
 * be refreshed by expireTag
 */
export declare function refresh(): void;
/**
 * This function allows you to purge [cached data](https://nextjs.org/docs/app/building-your-application/caching) on-demand for a specific path.
 *
 * Read more: [Next.js Docs: `revalidatePath`](https://nextjs.org/docs/app/api-reference/functions/revalidatePath)
 */
export declare function revalidatePath(originalPath: string, type?: 'layout' | 'page'): undefined;
export {};
