import { NextResponse } from 'next/server';

export async function GET() {
  try {
    const now = new Date();
    
    const alerts = [
      {
        alertId: 'ALT-001',
        timestamp: new Date(now.getTime() - 30 * 60000).toISOString(),
        type: 'THRESHOLD',
        severity: 'CRITICAL',
        category: 'Stock',
        title: 'Niveau Critique Cuve Diesel',
        description: 'Cuve #1 Diesel sous le seuil critique (5%)',
        metric: 'Tank Level',
        currentValue: 5,
        threshold: 10,
        status: 'OPEN',
      },
      {
        alertId: 'ALT-002',
        timestamp: new Date(now.getTime() - 60 * 60000).toISOString(),
        type: 'ANOMALY',
        severity: 'HIGH',
        category: 'Ventes',
        title: 'Baisse Anormale des Ventes',
        description: 'Volume des ventes -65% par rapport à la moyenne',
        metric: 'Sales Volume',
        currentValue: 350,
        threshold: 1000,
        status: 'ACKNOWLEDGED',
      },
      {
        alertId: 'ALT-003',
        timestamp: new Date(now.getTime() - 90 * 60000).toISOString(),
        type: 'DISCREPANCY',
        severity: 'HIGH',
        category: 'Stock',
        title: 'Écart Inventaire SP95',
        description: 'Différence de 150L entre théorique et physique',
        metric: 'Stock Discrepancy',
        currentValue: 150,
        threshold: 50,
        status: 'OPEN',
      },
      {
        alertId: 'ALT-004',
        timestamp: new Date(now.getTime() - 120 * 60000).toISOString(),
        type: 'SYSTEM',
        severity: 'MEDIUM',
        category: 'Système',
        title: 'Connexion Pompe Instable',
        description: 'Pompe #3 perte de connexion intermittente',
        metric: 'Connection',
        currentValue: 45,
        threshold: 95,
        status: 'ACKNOWLEDGED',
      },
      {
        alertId: 'ALT-005',
        timestamp: new Date(now.getTime() - 180 * 60000).toISOString(),
        type: 'SECURITY',
        severity: 'MEDIUM',
        category: 'Sécurité',
        title: 'Tentative Accès Non Autorisé',
        description: '3 tentatives de connexion échouées',
        metric: 'Login Attempts',
        currentValue: 3,
        threshold: 3,
        status: 'RESOLVED',
      },
      {
        alertId: 'ALT-006',
        timestamp: new Date(now.getTime() - 240 * 60000).toISOString(),
        type: 'THRESHOLD',
        severity: 'LOW',
        category: 'Stock',
        title: 'Stock Bas Café',
        description: 'Stock café sous 20% - commande suggérée',
        metric: 'Shop Stock',
        currentValue: 18,
        threshold: 20,
        status: 'OPEN',
      },
    ];

    const stats = {
      total: alerts.length,
      critical: alerts.filter(a => a.severity === 'CRITICAL').length,
      high: alerts.filter(a => a.severity === 'HIGH').length,
      medium: alerts.filter(a => a.severity === 'MEDIUM').length,
      low: alerts.filter(a => a.severity === 'LOW').length,
      open: alerts.filter(a => a.status === 'OPEN').length,
      acknowledged: alerts.filter(a => a.status === 'ACKNOWLEDGED').length,
      resolved: alerts.filter(a => a.status === 'RESOLVED').length,
    };

    return NextResponse.json({
      alerts,
      stats,
    });
  } catch (error) {
    console.error('Error fetching alerts:', error);
    return NextResponse.json(
      { error: 'Failed to fetch alerts' },
      { status: 500 }
    );
  }
}
