import { NextResponse } from 'next/server';
import connectDB from '@/lib/mongodb';
import { Customer } from '@/models';

/**
 * GET /api/customers
 * Retourne tous les clients pour la sélection
 */
export async function GET() {
  try {
    await connectDB();

    const customers = await Customer.find({})
      .select('first_name last_name loyalty_card_id')
      .lean();

    // Ajouter le client par défaut "Divers"
    const allCustomers = [
      {
        _id: 'DIVERS',
        first_name: 'Client',
        last_name: 'Divers',
        loyalty_card_id: null,
      },
      ...customers,
    ];

    return NextResponse.json({
      success: true,
      data: allCustomers,
    });
  } catch (error) {
    console.error('Erreur API Customers:', error);
    return NextResponse.json(
      {
        success: false,
        error: 'Erreur lors de la récupération des clients',
      },
      { status: 500 }
    );
  }
}
